/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xpropdef.h
 * -----------------------------------------------------------------*/


#ifndef XPROPDEFS_H_INCLUDED                               
#define XPROPDEFS_H_INCLUDED

#ifndef CLI
#define CLI
#endif



/* --------------------------------------------------------------------------
 * Onboard Resource definitions
 * -------------------------------------------------------------------------- */

#define BX_RESOURCE_SIZE 29

  /* TODO: check lockable resources */
CLI typedef enum {
  BX_RESLOCK_EXERCISER,          /* @exe */
  BX_RESLOCK_OBSERVER,           /* @obs */
  BX_RESLOCK_PERFORMANCE,        /* @per */
  BX_RESLOCK_ANALYZER            /* @ana */
} bx_resourcetype;

/* Note; BX_RESLOCK_MEM_xxx enums are used primarily by the firmware */


/* ---------------------------------------------------------------
 * Onboard version information ...
 * NOTE:
 * Do only append to this structure, never insert. Numbers have to
 * be kept over different software versions to maintain updatability.
 * CZ
 * --------------------------------------------------------------- */
CLI typedef enum {
  BX_VERSION_PRODUCT,        /* @product      */
  BX_VERSION_SERIALNO,       /* @serialno     */
  BX_VERSION_BOARDID,        /* @boardid      */
  BX_VERSION_XILINX,         /* @xilinx       */
  BX_VERSION_FIRMWARE,       /* @firmware     */
  BX_VERSION_CORE,           /* @core         */
  BX_VERSION_ALTERA,         /* @altera       */
  BX_VERSION_CAPI,           /* @capi         */
  BX_VERSION_MEPHISTO,       /* @mephisto     */
  BX_VERSION_TEAM,           /* @team         */
  BX_VERSION_FIRMWARE_DATE,  /* @firmwaredate */
  BX_VERSION_FAUST,          /* @faust        */
  BX_VERSION_COCO            /* @coco         */
} bx_versiontype; 

CLI typedef enum {
  BX_DATECODE_XILINX,        /* @datexilinx */
  BX_DATECODE_DTALTERA       /* @datedtaltera */
} bx_datecodeproptype;

/* ---------------------------------------------------------------
 * 23.1.98; bx_cpuproptype (CPU Port Programming) -> cpupdefs.h
 * --------------------------------------------------------------- */

CLI  /* DEF_START ~G_BX_MRUN */
#define BX_MRUN_OFF    16                 /* @mrunoff */
CLI  /* DEF_END */


/* ---------------------------------------------------------------
 * Type Definitions for Miscelleaneous Functions                 
 * --------------------------------------------------------------- */

#if 0
CLI  /* DEF_START ~G_BX_RSTMODE */
#define BX_RSTMODE_RESETSM      0x1  /* @resetsm */
#define BX_RSTMODE_RESETALL     0x0  /* @resetall */
#define BX_RSTMODE_RESETCONFIG  0x2  /* @resetconfig */
CLI  /* DEF_END */
#endif

#define BX_CAPIPROP_SIZE        2
CLI typedef enum {
  BX_CAPI_BLOCKMAX,    /* @blkmax */
  BX_CAPI_QUICKUPDATE    /* @quickupdate */
} bx_capiproptype;


typedef enum {
  BX_MBLOCK_MEM_0,
  BX_MBLOCK_MEM_1,
  BX_MBLOCK_MEM_2,
  BX_MBLOCK_MEM_3,
  BX_MBLOCK_MEM_4,
  BX_MBLOCK_MEM_5,
  BX_MBLOCK_MEM_6,
  BX_MBLOCK_MEM_7,
  BX_MBLOCK_MEM_8,
  BX_MBLOCK_MEM_9,
  BX_MATTR_MEM_0,
  BX_MATTR_MEM_1,
  BX_MATTR_MEM_2,
  BX_MATTR_MEM_3,
  BX_MATTR_MEM_4,
  BX_MATTR_MEM_5,
  BX_MATTR_MEM_6,
  BX_MATTR_MEM_7,
  BX_MATTR_MEM_8,
  BX_MATTR_MEM_9,
  BX_MATTR_MEM_10,
  BX_MATTR_MEM_11,
  BX_MATTR_MEM_12,
  BX_MATTR_MEM_13,
  BX_MATTR_MEM_14,
  BX_MBYTEN_MEM_0,
  BX_TATTR_MEM_0,
  BX_TATTR_MEM_1,
  BX_TATTR_MEM_2,
  BX_TATTR_MEM_3,
  BX_TATTR_MEM_4,
  BX_TATTR_MEM_5,
  BX_TATTR_MEM_6,
  BX_TATTR_MEM_7,
  BX_TATTR_MEM_8,
  BX_AMAP_MEM_0,
  BX_AMAP_MEM_1,
  BX_AMAP_MEM_2,
  BX_CONTEXT_MEM,
  BX_ISSEQ_MEM,
  BX_MSEQ_MEM,
  BX_TSEQ_MEM,
  BX_PERFSEQ_MEM_0,
  BX_PERFSEQ_MEM_1,
  BX_PERFSEQ_MEM_2,
  BX_PERFSEQ_MEM_3,
  BX_PERFSEQ_MEM_4,
  BX_PERFSEQ_MEM_5,
  BX_PERFSEQ_MEM_6,
  BX_PERFSEQ_MEM_7,
  BX_CSTRULE_MEM_0,
  BX_CSTRULE_MEM_1,
  BX_CSTRULE_MEM_2,
  BX_CSTRULE_MEM_3,
  BX_CSTRULE_MEM_4,
  BX_CSTRULE_MEM_5,
  BX_CSTRULE_MEM_6,
  BX_CSTRULE_MEM_7,
  BX_TRIGIOSEQ_MEM,
  BX_TRIGSEQ_MEM,
  BX_SELFTEST_COUNT    /* internal use only */
} bx_selftesttype;


/* ---------------------------------------------------------------
 * Defines for Trace & External Trigger Functions
 * --------------------------------------------------------------- */
CLI /* DEF_START ~G_BX_G14 */
#define BX_HBMODE_ON            0x1  /* @on  */
#define BX_HBMODE_OFF           0x0  /* @off */
#define BX_E2925_COMPATIBLE     0x0  /* @e2925  */
#define BX_PERFORMANCE          0x1  /* @perf */
#define BX_PATT0MODE_STANDARD   0x0  /* @standard */
#define BX_PATT0MODE_DIFFERENTIAL 0x1 /* @differential */
#define BX_TRIG15IO_INPUT        0x0  /* @in  */
#define BX_TRIG15IO_OUTPUT       0x1  /* @out */
CLI /* DEF_END */



/* ---------------------------------------------------------------
 * Type Definitions for Host to PCI Access Functions
 * --------------------------------------------------------------- */
CLI typedef enum {
  BX_ADDRSPACE_CONFIG,       /* @config      */
  BX_ADDRSPACE_IO,           /* @io          */
  BX_ADDRSPACE_MEM           /* @mem         */
} bx_addrspacetype;


/* ---------------------------------------------------------------
 * Type Definitions for Test Functions
 * --------------------------------------------------------------- */
CLI typedef enum {
  BX_TST_BANDWIDTH,    /* @bw */
  BX_TST_BLKLENGTH,    /* @blklen */
  BX_TST_DATAPATTERN,    /* @dpat */
  BX_TST_PROTOCOL,    /* @prot */
  BX_TST_COMPARE,    /* @comp */
  BX_TST_STARTADDR,    /* @start */
  BX_TST_NOFBYTES,    /* @nob */
  BX_TST_SOURCEADDR,    /* @source */
  BX_TST_DESTINADDR,    /* @dest */
  BX_TST_TIMEDIST,    /* @timedist */
  BX_TST_TIMELIMIT    /* @timelimit */
} bx_testproptype;

CLI typedef enum {
  BX_TIM_ACTUALVAL,    /* @actual */
  BX_TIM_TESTERROR,    /* @testerror */
  BX_TIM_PROTERROR,    /* @proterror */
  BX_TIM_TRACETRIG    /* @trig */
} bx_timertype;


/* ---------------------------------------------------------------
 * Debug Switches for onboard debugging
 * --------------------------------------------------------------- */
CLI typedef enum {
  BX_FW_BOOT,                    /* @boot */
  BX_FW_ANALYZER,                /* @ana */
  BX_FW_EXERCISER,               /* @exe */
  BX_FW_PARSE,                   /* @parse */
  BX_FW_HAL,                     /* @hal */
  BX_FW_EDITSET,                 /* @edit */
  BX_FW_HOSTINT,                 /* @host */
  BX_FW_PPR,                     /* @ppr */
  BX_FW_SST,                     /* @sst */
  BX_FW_RS232,                   /* @rs232 */
  BX_FW_PARALLEL,                /* @para */
  BX_FW_PCI,                     /* @pci */
  BX_FW_DECODE,                  /* @dec */
  BX_FW_SERVICES,                /* @service */
  BX_FW_PERF,                    /* @perf */
  BX_FW_TRACEINOUT,              /* @trace */
  BX_FW_STACK,            /* @stack */
  BX_FW_SYSTEM,                  /* @system */
  BX_FW_APPLICATION,             /* @appl */
  BX_FW_PSOS,            /* @psos */
  BX_FW_PPISTATE,                /* @ppi */
  BX_FW_PPIOTHER,                /* @ppiother */
  BX_FW_PORTS,                   /* @ports */
  BX_FW_ALL = 255                /* @all */
} bx_debugtype;

/* ---------------------------------------------------------------
 * Defines for tiny LED Functions
 * --------------------------------------------------------------- */
CLI /* DEF_START ~G_BX_LED */
#define BX_LED_USER            0x1  /* @leduser */
#define BX_LED_CARD            0x0  /* @ledcard */
CLI /* DEF_END */


/* ---------------------------------------------------------------
 * Defines for Test Functions
 * --------------------------------------------------------------- */
CLI /* DEF_START ~G_BX_DATAPATTERN */
#define BX_DATAPATTERN_RANDOM   0x0  /* @dprandom */
#define BX_DATAPATTERN_FIX      0x1  /* @dpfix */
#define BX_DATAPATTERN_TOGGLE   0x2  /* @dptoggle */
CLI /* DEF_END */

CLI /* DEF_START ~G_BX_PROTOCOL */
#define BX_PROTOCOL_LITE        0x0  /* @lite */
#define BX_PROTOCOL_MEDIUM      0x1  /* @medium */
#define BX_PROTOCOL_HARD        0x2  /* @hard */
CLI /* DEF_END */


/******************************************************************************/
/* The test command is a mask which defines how many and what type of entries 
 * will be added to a Master Block Page for EACH attribute page used for
 * each type of test.  
 *
 * Each type of test is made up of one or more of the following;
 * 1. Read to upper half of internal memory.
 * 2. Write from upper half of internal memory.
 * 3. Read to lower half of internal memory (necessary for compare).
 *
 */
#define PBP_READ_TO_UPPER_HALF      0x1
#define PBP_WRITE_FROM_UPPER_HALF   0x2
#define PBP_READ_TO_LOWER_HALF      0x4
#define PBP_COMPARE                 0x8

/* ALL BX_TSTCMD_ defines MUST be made up from the PBP_ defines above */

CLI /* DEF_START ~G_BX_TSTCMD */
#define BX_TSTCMD_INTGENERATE   0x0  /* @intgenerate */
#define BX_TSTCMD_TRAFFICMAKE   0x2  /* @trafficmake */
#define BX_TSTCMD_BLOCKMOVE     0x3  /* @blockmove */
#define BX_TSTCMD_READ             0x4  /* @read */
#define BX_TSTCMD_WRITEREAD     0x6  /* @writeread */
CLI /* DEF_END */


/* This table describes the bus addresses used for different test modes 
 * 
 *                          Read Src.           Write Dest.
 * BX_TSTCMD_TRAFFICMAKE       -                 Target
 * BX_TSTCMD_BLOCKMOVE       BX_TST_SOURCEADDR    BX_TST_DESTINADDR
 * BX_TSTCMD_READ            BX_TST_SOURCEADDR    BX_TST_SOURCEADDR
 * BX_TSTCMD_WRITEREAD       BX_TST_SOURCEADDR    BX_TST_SOURCEADDR
 */


#endif






